package gov.va.med.mhv.mrp.web.converter;

import java.io.Serializable;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.web.model.MyGoalTask;
import gov.va.med.mhv.mrp.web.model.MyGoalsExtension;

@Component
public class MyGoalExtensionsDTOConverter implements Converter<MyGoalsExtension, MyGoalsExtensionDTO>, Serializable {
	private static final long serialVersionUID = 1L;
	
	@Autowired
	private MyGoalTaskDTOConverter myGoalTaskConverter;

	@Override
	public MyGoalsExtensionDTO convert(MyGoalsExtension model) {
		MyGoalsExtensionDTO dto = new MyGoalsExtensionDTO();

		dto.setDescription(model.getDescription());
		dto.setGoalExtensionId(model.getGoalExtensionId());
		dto.setGoalExtensionSequenceNumber(model.getGoalExtensionSequenceNumber());
		dto.setGoalExtensionType(model.getGoalExtensionType());
		dto.setOplock(model.getOplock());
		
		if (model.getTasks() != null) {
			for (MyGoalTask task : model.getTasks()) {
				MyGoalTaskDTO taskDTO = myGoalTaskConverter.convert(task);
				dto.getMyGoalsTasks().add(taskDTO);
			}
		}

		return dto;
	}

}
